/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import panther.util.general.OpsOut;

public class FileBasedJournal {
    protected String fileName;
    protected File file;
    protected PrintWriter writer;

    public FileBasedJournal(String string, String string2) {
        this.fileName = string2;
        this.file = new File(string + File.separatorChar + string2 + ".journal");
    }

    public void open() throws Exception {
        this.file.getParentFile().mkdirs();
        this.writer = new PrintWriter(new FileOutputStream(this.file.getCanonicalPath(), true));
    }

    public void close() throws Exception {
        this.writer.close();
        this.writer = null;
    }

    public void writeRecord(String string) throws Exception {
        if (this.writer == null) {
            OpsOut.println("Attempt to write to closed Journal " + this.fileName);
            return;
        }
        this.writer.println(string);
        this.writer.flush();
    }

    public List getRecords() throws Exception {
        if (!this.file.exists()) {
            OpsOut.print("Journal " + this.fileName + " doesn't exist ... ");
            return new ArrayList();
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
        ArrayList<String> arrayList = new ArrayList<String>(5000);
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    protected String escape(String string) {
        if (string.indexOf("\n") >= 0) {
            throw new Error("Journal error");
        }
        return string;
    }

    protected String unescape(String string) {
        return string;
    }
}

